//
//  RegisterBiometricViewController.swift
//  Demo iOS
//
//  Created by Benoit Vasseur on 06/07/2022.
//

import UIKit

class RegisterBiometricViewController: BaseViewController {

    @IBOutlet weak var subtitleText: UILabel!
    @IBOutlet weak var pinField: UITextField!
    @IBOutlet weak var pinView: UIView!
    @IBOutlet weak var registerButton: UIButton!

    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "Register Biometrics"
        subtitleText.isHidden = true
        registerButton.isHidden = true
        
        startRegister()
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        checkIfCurrentBiokeyExists()
    }
    
    func checkIfCurrentBiokeyExists() {
        let biokeyExists = BiokeyService.sharedInstance.fetchBiokey() != nil
        self.subtitleText.isHidden = !biokeyExists
    }
    
    func startRegister() {
        let result = InweboService.sharedInstance.startRegisterBiokey()
        if result == IW_ERR_OK {
            self.registerButton.isHidden = false
            let pinMode = InweboService.sharedInstance.getPinMode()
            self.pinView.isHidden = pinMode == IW_PINMODE_NONE
        } else {
            self.showErrorFor(code: result)
        }
    }
    
    func registerBiokey() {
        let pin = self.pinField.text ?? ""
        Task {
            if await BiokeyService.sharedInstance.activateBiometrics() {
                DispatchQueue.global().async {
                    let biokey = BiokeyService.sharedInstance.createBiokey()
                    let result = InweboService.sharedInstance.finalizeRegisterBiokey(biokey: biokey, pin: pin)
                    DispatchQueue.main.async {
                        if result == IW_ERR_OK {
                            self.showAlert(title: "Biokey", message: "Biokey successfully registered", button1: (name: "Ok", action: {
                                _ in self.navigationController?.popViewController(animated: true)
                            }), button2: nil)
                        } else {
                            self.showErrorFor(code: result)
                        
                        }
                    }
                }
            }
        }
    }
    
    @IBAction func registerTouched(_ sender: Any) {
        registerBiokey()
    }
}
